% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_call.R
\name{get_call}
\alias{get_call}
\title{Get the model's function call}
\usage{
get_call(x)
}
\arguments{
\item{x}{A fitted mixed model.}
}
\value{
A function call.
}
\description{
Returns the model's function call when available.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_call(m)

if (require("lme4")) {
  m <- lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris)
  get_call(m)
}
}
