% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efaModel.R
\name{efaModel}
\alias{efaModel}
\title{Generates an EFA model to be used by lavaan and regsem
Function created by Florian Scharf for the paper
Should regularization replace simple structure rotation in
Exploratory Factor Analysis -- Scharf & Nestler (in press at SEM)}
\usage{
efaModel(nFactors, variables)
}
\arguments{
\item{nFactors}{Number of latent factors to generate.}

\item{variables}{Names of variables to be used as indicators}
}
\value{
model Full EFA model parameters.
}
\description{
Generates an EFA model to be used by lavaan and regsem
Function created by Florian Scharf for the paper
Should regularization replace simple structure rotation in
Exploratory Factor Analysis -- Scharf & Nestler (in press at SEM)
}
\examples{
\dontrun{
HS <- data.frame(scale(HolzingerSwineford1939[,7:15]))
# Note to find number of factors, recommended to use
# fa.parallel() from the psych package
# using the wrong number of factors can distort the results
mod = efaModel(3, colnames(HS))

semFit = sem(mod, data = HS, int.ov.free = FALSE, int.lv.free = FALSE,
            std.lv = TRUE, std.ov = TRUE, auto.fix.single = FALSE, se = "none")

# note it requires smaller penalties than other applications
reg.out2 = cv_regsem(model = semFit, pars_pen = "loadings",
                    mult.start = TRUE, multi.iter = 10,
                    n.lambda = 100, type = "lasso", jump = 10^-5, lambda.start = 0.001)
reg.out2
plot(reg.out2) # note that the solution jumps around -- make sure best fit makes sense
}
}
\keyword{analysis}
\keyword{fa}
\keyword{factor}
