% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind}
\alias{bind}
\alias{rbind.sftime}
\alias{cbind.sftime}
\title{Bind rows (features) of \code{sftime} objects}
\usage{
\method{rbind}{sftime}(..., deparse.level = 1)

\method{cbind}{sftime}(..., deparse.level = 1, sf_column_name = NULL, tc_column_name = NULL)
}
\arguments{
\item{...}{Objects to bind; note that for the \code{rbind} and \code{cbind} 
methods, all objects have to be of class \code{sftime}; see 
\code{\link{dotsMethods}}.}

\item{deparse.level}{An integer value; see \code{\link{rbind}}.}

\item{sf_column_name}{Character value; specifies the active geometry column; 
passed on to \code{\link{st_sftime}}.}

\item{tc_column_name}{Character value; specifies active time column; passed 
on to \code{\link{st_sftime}}.}
}
\value{
\code{rbind} combines all \code{sftime} objects in \code{...} 
row-wise and returns the combined \code{sftime} object.

\code{cbind} combines all \code{sftime} objects in \code{...} 
column-wise and returns the combined \code{sftime} object. When called with 
multiple \code{sftime} objects warns about multiple time and geometry columns 
present when the time and geometry columns to use are not specified by using 
arguments \code{tc_column_name} and \code{sf_column_name}; see also 
\link{st_sftime}.
}
\description{
Bind rows (features) of \code{sftime} objects

Bind columns (variables) of \code{sftime} objects
}
\details{
Both \code{rbind} and \code{cbind} have non-standard method dispatch 
(see \link[base]{cbind}): the \code{rbind} or \code{cbind} method for 
\code{sftime} objects is only called when all arguments to be combined are of 
class \code{sftime}.

If you need to \code{cbind} e.g. a \code{data.frame} to an \code{sf}, 
use \code{\link{data.frame}} directly and use \code{\link{st_sftime}} on its 
result, or use \code{\link[dplyr:bind]{bind_cols}}; see examples.
}
\examples{
g1 <- st_sfc(st_point(1:2))
x1 <- st_sftime(a = 3, geometry = g1, time = Sys.time())

g2 <- st_sfc(st_point(c(4, 6)))
x2 <- st_sftime(a = 4, geometry = g2, time = Sys.time())

rbind(x1, x2) # works because both tc1 and tc2 have the same class

\dontrun{
st_time(x2) <- 1
rbind(x1, x2) # error because both tc1 and tc2 do not have the same class
}

cbind(x1, x2) 

if (require(dplyr))
  dplyr::bind_cols(x1, x2)
  
df <- data.frame(x = 3)   
st_sftime(data.frame(x1, df))   
  
}
