% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{UnhandledHTTPRequestError}
\alias{UnhandledHTTPRequestError}
\alias{vcr_last_error}
\title{UnhandledHTTPRequestError}
\usage{
vcr_last_error()
}
\description{
Handle http request errors
}
\details{
How this error class is used:
If \code{record="once"} we trigger this.

Users can use vcr in the context of both \code{\link[=use_cassette]{use_cassette()}}
and \code{\link[=insert_cassette]{insert_cassette()}}

For the former, all requests go through the call_block
But for the latter, requests go through webmockr.

Where is one place where we can put UnhandledHTTPRequestError
that will handle both use_cassette and insert_cassette?
}
\section{Error situations where this is invoked}{

\itemize{
\item \code{record=once} AND there's a new request that doesn't match
the one in the cassette on disk
\itemize{
\item in webmockr: if no stub found and there are recorded
interactions on the cassette, and record = once, then
error with UnhandledHTTPRequestError
\itemize{
\item but if record != once, then allow it, unless record == none
}
}
\item others?
}
}

\examples{
\dontrun{
vcr_configure(dir = tempdir())
cassettes()
insert_cassette("turtle")
request <- Request$new("post", 'https://hb.opencpu.org/post?a=5',
  "", list(foo = "bar"))

err <- UnhandledHTTPRequestError$new(request)
err$request_description()
err$current_matchers()
err$match_request_on_headers()
err$match_request_on_body()
err$formatted_headers()
cat(err$formatted_headers(), "\n")
cat(err$cassettes_description(), "\n")
cat(err$cassettes_list(), "\n")
err$formatted_suggestions()
cat(err$format_bullet_point('foo bar', 1), "\n")
err$suggestion_for("use_new_episodes")
err$suggestions()
err$no_cassette_suggestions()
err$record_mode_suggestion()
err$has_used_interaction_matching()
err$match_requests_on_suggestion()

# err$construct_message()

# cleanup
eject_cassette("turtle")
unlink(tempdir())
}
\dontrun{
# vcr_last_error()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request}}{a \link{Request} object}

\item{\code{cassette}}{a cassette name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UnhandledHTTPRequestError-new}{\code{UnhandledHTTPRequestError$new()}}
\item \href{#method-UnhandledHTTPRequestError-run}{\code{UnhandledHTTPRequestError$run()}}
\item \href{#method-UnhandledHTTPRequestError-construct_message}{\code{UnhandledHTTPRequestError$construct_message()}}
\item \href{#method-UnhandledHTTPRequestError-request_description}{\code{UnhandledHTTPRequestError$request_description()}}
\item \href{#method-UnhandledHTTPRequestError-current_matchers}{\code{UnhandledHTTPRequestError$current_matchers()}}
\item \href{#method-UnhandledHTTPRequestError-match_request_on_headers}{\code{UnhandledHTTPRequestError$match_request_on_headers()}}
\item \href{#method-UnhandledHTTPRequestError-match_request_on_body}{\code{UnhandledHTTPRequestError$match_request_on_body()}}
\item \href{#method-UnhandledHTTPRequestError-formatted_headers}{\code{UnhandledHTTPRequestError$formatted_headers()}}
\item \href{#method-UnhandledHTTPRequestError-cassettes_description}{\code{UnhandledHTTPRequestError$cassettes_description()}}
\item \href{#method-UnhandledHTTPRequestError-cassettes_list}{\code{UnhandledHTTPRequestError$cassettes_list()}}
\item \href{#method-UnhandledHTTPRequestError-get_help}{\code{UnhandledHTTPRequestError$get_help()}}
\item \href{#method-UnhandledHTTPRequestError-formatted_suggestions}{\code{UnhandledHTTPRequestError$formatted_suggestions()}}
\item \href{#method-UnhandledHTTPRequestError-format_bullet_point}{\code{UnhandledHTTPRequestError$format_bullet_point()}}
\item \href{#method-UnhandledHTTPRequestError-format_foot_note}{\code{UnhandledHTTPRequestError$format_foot_note()}}
\item \href{#method-UnhandledHTTPRequestError-suggestion_for}{\code{UnhandledHTTPRequestError$suggestion_for()}}
\item \href{#method-UnhandledHTTPRequestError-suggestions}{\code{UnhandledHTTPRequestError$suggestions()}}
\item \href{#method-UnhandledHTTPRequestError-no_cassette_suggestions}{\code{UnhandledHTTPRequestError$no_cassette_suggestions()}}
\item \href{#method-UnhandledHTTPRequestError-record_mode_suggestion}{\code{UnhandledHTTPRequestError$record_mode_suggestion()}}
\item \href{#method-UnhandledHTTPRequestError-has_used_interaction_matching}{\code{UnhandledHTTPRequestError$has_used_interaction_matching()}}
\item \href{#method-UnhandledHTTPRequestError-match_requests_on_suggestion}{\code{UnhandledHTTPRequestError$match_requests_on_suggestion()}}
\item \href{#method-UnhandledHTTPRequestError-clone}{\code{UnhandledHTTPRequestError$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-new"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{UnhandledHTTPRequestError} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$new(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{(Request) a \link{Request} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{UnhandledHTTPRequestError} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-run"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-run}{}}}
\subsection{Method \code{run()}}{
Run unhandled request handling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
various
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-construct_message"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-construct_message}{}}}
\subsection{Method \code{construct_message()}}{
Construct and execute stop message for why request failed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$construct_message()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a stop message
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-request_description"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-request_description}{}}}
\subsection{Method \code{request_description()}}{
construct request description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$request_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-current_matchers"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-current_matchers}{}}}
\subsection{Method \code{current_matchers()}}{
get current request matchers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$current_matchers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-match_request_on_headers"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-match_request_on_headers}{}}}
\subsection{Method \code{match_request_on_headers()}}{
are headers included in current matchers?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_request_on_headers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-match_request_on_body"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-match_request_on_body}{}}}
\subsection{Method \code{match_request_on_body()}}{
is body includled in current matchers?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_request_on_body()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-formatted_headers"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-formatted_headers}{}}}
\subsection{Method \code{formatted_headers()}}{
get request headers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$formatted_headers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-cassettes_description"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-cassettes_description}{}}}
\subsection{Method \code{cassettes_description()}}{
construct description of current or lack thereof cassettes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$cassettes_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-cassettes_list"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-cassettes_list}{}}}
\subsection{Method \code{cassettes_list()}}{
cassette details
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$cassettes_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-get_help"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-get_help}{}}}
\subsection{Method \code{get_help()}}{
get help message for non-verbose error
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$get_help()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-formatted_suggestions"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-formatted_suggestions}{}}}
\subsection{Method \code{formatted_suggestions()}}{
make suggestions for what to do
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$formatted_suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-format_bullet_point"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-format_bullet_point}{}}}
\subsection{Method \code{format_bullet_point()}}{
add bullet point to beginning of a line
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$format_bullet_point(lines, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lines}}{(character) vector of strings}

\item{\code{index}}{(integer) a number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-format_foot_note"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-format_foot_note}{}}}
\subsection{Method \code{format_foot_note()}}{
make a foot note
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$format_foot_note(url, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{(character) a url}

\item{\code{index}}{(integer) a number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-suggestion_for"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-suggestion_for}{}}}
\subsection{Method \code{suggestion_for()}}{
get a suggestion by key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$suggestion_for(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(character) a character string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-suggestions"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-suggestions}{}}}
\subsection{Method \code{suggestions()}}{
get all suggestions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-no_cassette_suggestions"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-no_cassette_suggestions}{}}}
\subsection{Method \code{no_cassette_suggestions()}}{
get all no cassette suggestions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$no_cassette_suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-record_mode_suggestion"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-record_mode_suggestion}{}}}
\subsection{Method \code{record_mode_suggestion()}}{
get the appropriate record mode suggestion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$record_mode_suggestion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-has_used_interaction_matching"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-has_used_interaction_matching}{}}}
\subsection{Method \code{has_used_interaction_matching()}}{
are there any used interactions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$has_used_interaction_matching()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-match_requests_on_suggestion"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-match_requests_on_suggestion}{}}}
\subsection{Method \code{match_requests_on_suggestion()}}{
match requests on suggestion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_requests_on_suggestion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnhandledHTTPRequestError-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UnhandledHTTPRequestError-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
