/*
 * Decompiled with CFR 0.152.
 */
package glguerin.authkit;

import java.io.UnsupportedEncodingException;

public final class Privilege {
    public static final Privilege EMPTY;
    private static final byte[] NOVALUE;
    private final String name;
    private final byte[] value;
    private final int flags;
    private final String asStr;

    public Privilege(String string) {
        this(string, null, 0);
    }

    public Privilege(String string, Object object, int n) {
        if (string == null) {
            throw new NullPointerException("Name can't be null");
        }
        byte[] byArray = NOVALUE;
        StringBuffer stringBuffer = new StringBuffer(string).append(":");
        if (object != null) {
            if (object instanceof byte[]) {
                byArray = (byte[])((byte[])object).clone();
                stringBuffer.append("byte[").append(byArray.length).append("]");
            } else {
                try {
                    String string2 = object.toString();
                    byArray = string2.getBytes("UTF8");
                    stringBuffer.append(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = NOVALUE;
                    stringBuffer.append("Unencodeable ").append(object.getClass().getName());
                }
            }
        }
        this.name = string;
        this.value = byArray;
        this.flags = n;
        this.asStr = stringBuffer.append(":").append(n).toString();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return this.asStr;
    }

    public int hashCode() {
        return this.asStr.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Privilege) {
            Privilege privilege = (Privilege)object;
            if (this.name.equals(privilege.name) && this.flags == privilege.flags && this.value.length == privilege.value.length) {
                byte[] byArray = this.value;
                byte[] byArray2 = privilege.value;
                int n = 0;
                int n2 = byArray.length;
                while (n < n2) {
                    if (byArray[n] != byArray2[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    static {
        NOVALUE = new byte[0];
        EMPTY = new Privilege("");
    }
}

