/*
 * Decompiled with CFR 0.152.
 */
package org.helios.helpers.beansupport;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.helios.jmx.dynamic.annotations.JMXAttribute;
import org.helios.jmx.dynamic.annotations.JMXManagedObject;
import org.helios.jmx.dynamic.annotations.JMXOperation;
import org.helios.jmx.dynamic.annotations.JMXParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReflection {
    protected Class clazz = null;
    protected boolean managed = false;
    protected Method[] methods = null;
    protected JMXManagedObject jmxManagedObject = null;
    protected boolean managedDeclared = false;
    protected boolean managedAnnotated = false;
    protected BeanDescriptor beanDescriptor = null;
    protected BeanInfo beanInfo = null;
    protected Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    protected Map<JMXAttribute, Method> jmxAttributes = new HashMap<JMXAttribute, Method>();
    protected Map<Method, JMXAttribute> jmxAttributesByMethod = new HashMap<Method, JMXAttribute>();
    protected Map<JMXOperation, Method> jmxOperations = new HashMap<JMXOperation, Method>();
    protected Map<Method, JMXOperation> jmxOperationsByMethod = new HashMap<Method, JMXOperation>();
    protected Map<JMXOperation, Set<JMXParameter>> jmxParameters = new HashMap<JMXOperation, Set<JMXParameter>>();
    protected Set<String> beanAttributeNames = new HashSet<String>();
    protected Map<String, String> beanAttributeTypes = new TreeMap<String, String>();
    protected Map<JMXAttribute, Method> jmxAttributeGetters = new TreeMap<JMXAttribute, Method>();
    protected Map<JMXAttribute, Method> jmxAttributeSetters = new TreeMap<JMXAttribute, Method>();
    protected static Logger log = Logger.getLogger(BeanReflection.class);

    public BeanReflection(Object pojo) {
        int a = 0;
        int o = 0;
        int p = 0;
        this.clazz = pojo.getClass();
        this.managed = this.clazz.isAnnotationPresent(JMXManagedObject.class);
        if (this.managed) {
            this.jmxManagedObject = this.clazz.getAnnotation(JMXManagedObject.class);
            this.managedDeclared = this.jmxManagedObject.declared();
            this.managedAnnotated = this.jmxManagedObject.annotated();
            this.methods = this.managedDeclared ? this.clazz.getDeclaredMethods() : this.clazz.getMethods();
            for (Method m : this.methods) {
                JMXOperation jo;
                if (m.isAnnotationPresent(JMXAttribute.class)) {
                    JMXAttribute ja = m.getAnnotation(JMXAttribute.class);
                    if (ja.expose()) {
                        this.jmxAttributes.put(ja, m);
                        this.jmxAttributesByMethod.put(m, ja);
                        ++a;
                    }
                    if (m.getParameterTypes().length == 0) {
                        this.jmxAttributeGetters.put(ja, m);
                    } else {
                        this.jmxAttributeSetters.put(ja, m);
                    }
                }
                if (!m.isAnnotationPresent(JMXOperation.class) || !(jo = m.getAnnotation(JMXOperation.class)).expose()) continue;
                this.jmxOperations.put(jo, m);
                this.jmxOperationsByMethod.put(m, jo);
                ++o;
                Map<Integer, JMXParameter> params = this.getJMXParameters(m);
                if (params.size() <= 0) continue;
                this.jmxParameters.put(jo, new HashSet<JMXParameter>(params.values()));
                p += params.size();
            }
        }
        BeanReflection.log("Added Attributes/Operations/Parameters:" + a + "/" + o + "/" + p);
        this.beanDescriptor = new BeanDescriptor(this.clazz);
        try {
            this.beanInfo = Introspector.getBeanInfo(this.clazz);
            for (PropertyDescriptor pd : this.beanInfo.getPropertyDescriptors()) {
                if (!this.isDeclared(pd)) continue;
                this.beanAttributeNames.add(pd.getName());
                this.propertyDescriptors.put(pd.getName(), pd);
                this.beanAttributeTypes.put(pd.getName(), pd.getPropertyType().getName());
                Method getMethod = pd.getReadMethod();
                Method setMethod = pd.getWriteMethod();
                JMXAttribute attributeAnnotation = null;
                if (getMethod != null && getMethod.isAnnotationPresent(JMXAttribute.class)) {
                    attributeAnnotation = getMethod.getAnnotation(JMXAttribute.class);
                    this.propertyDescriptors.put(attributeAnnotation.name(), pd);
                }
                if (setMethod == null || !setMethod.isAnnotationPresent(JMXAttribute.class) || this.propertyDescriptors.containsKey((attributeAnnotation = setMethod.getAnnotation(JMXAttribute.class)).name())) continue;
                this.propertyDescriptors.put(attributeAnnotation.name(), pd);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to introspect bean", e);
        }
    }

    protected boolean isDeclared(PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        boolean dec = false;
        dec = readMethod != null && readMethod.getDeclaringClass().equals(this.clazz) && !readMethod.getDeclaringClass().equals(Object.class) || writeMethod != null && writeMethod.getDeclaringClass().equals(this.clazz) && !writeMethod.getDeclaringClass().equals(Object.class);
        return dec;
    }

    protected Map<Integer, JMXParameter> getJMXParameters(Method method) {
        HashMap<Integer, JMXParameter> params = new HashMap<Integer, JMXParameter>();
        Annotation[][] pAnns = method.getParameterAnnotations();
        int index = 0;
        Annotation[][] arr$ = pAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] anns;
            for (Annotation ann : anns = arr$[i$]) {
                if (!(ann instanceof JMXParameter)) continue;
                params.put(index, (JMXParameter)ann);
            }
            ++index;
        }
        return params;
    }

    public Class getType() {
        return this.clazz;
    }

    public boolean isManagedDeclared() {
        return this.managedDeclared;
    }

    public boolean isManagedAnnotated() {
        return this.managedAnnotated;
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Map<String, PropertyDescriptor> getJMXPropertyDescriptors(Object pojo) {
        this.validatePojoType(pojo);
        HashMap<String, PropertyDescriptor> pDesc = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : this.propertyDescriptors.values()) {
            if (pd.getWriteMethod() != null && this.jmxAttributesByMethod.containsKey(pd.getWriteMethod())) {
                pDesc.put(this.jmxAttributesByMethod.get(pd.getWriteMethod()).name(), pd);
            }
            if (pd.getReadMethod() == null || !this.jmxAttributesByMethod.containsKey(pd.getReadMethod())) continue;
            pDesc.put(this.jmxAttributesByMethod.get(pd.getReadMethod()).name(), pd);
        }
        return pDesc;
    }

    public Set<String> getJMXAttributeNames(Object pojo) {
        this.validatePojoType(pojo);
        HashSet<String> jmxAttributeNames = new HashSet<String>();
        for (Method m : this.jmxAttributes.values()) {
            jmxAttributeNames.add(this.getJMXAttributeName(m, pojo));
        }
        return new TreeSet<String>(jmxAttributeNames);
    }

    public Set<String> getAttributeNames(Object pojo) {
        this.validatePojoType(pojo);
        TreeSet<String> attributeNames = new TreeSet<String>();
        Map<String, String> jmxAttrs = this.getBeanToJMXAttributeNames(pojo);
        Set<String> beanAttrs = this.getBeanAttributeNames();
        for (String s : beanAttrs) {
            if (jmxAttrs.containsKey(s)) {
                attributeNames.add(jmxAttrs.get(s));
                continue;
            }
            attributeNames.add(s);
        }
        return attributeNames;
    }

    public String getJMXAttributeName(Method method, Object pojo) {
        try {
            JMXAttribute attr = method.getAnnotation(JMXAttribute.class);
            if (attr.introspectName()) {
                return (String)this.clazz.getMethod(attr.name(), new Class[0]).invoke(pojo, new Object[0]);
            }
            return attr.name();
        }
        catch (Exception e) {
            throw new RuntimeException("Method [" + method.getName() + "] Is Not Annotated With JMXAttribute.");
        }
    }

    public String getJMXAttributeDescription(Method method, Object pojo) {
        this.validatePojoType(pojo);
        try {
            JMXAttribute attr = method.getAnnotation(JMXAttribute.class);
            if (attr.introspectDescription()) {
                return (String)this.clazz.getMethod(attr.description(), new Class[0]).invoke(pojo, new Object[0]);
            }
            return attr.description();
        }
        catch (Exception e) {
            throw new RuntimeException("Method [" + method.getName() + "] Is Not Annotated With JMXAttribute.");
        }
    }

    public Map<String, String> getJMXAttributeDescriptions(Object pojo) {
        this.validatePojoType(pojo);
        TreeMap<String, String> jmxAttrDescs = new TreeMap<String, String>();
        for (Method method : this.jmxAttributesByMethod.keySet()) {
            jmxAttrDescs.put(this.getJMXAttributeName(method, pojo), this.getJMXAttributeDescription(method, pojo));
        }
        return jmxAttrDescs;
    }

    public Map<String, String> getAttributeDescriptions(Object pojo) {
        TreeMap<String, String> attrDescs = new TreeMap<String, String>(this.getJMXAttributeDescriptions(pojo));
        Collection<PropertyDescriptor> jmxPds = this.getJMXPropertyDescriptors(pojo).values();
        for (PropertyDescriptor pd : this.propertyDescriptors.values()) {
            if (jmxPds.contains(pd)) continue;
            attrDescs.put(pd.getName(), "MBean Attribute");
        }
        return attrDescs;
    }

    public Map<String, String> getBeanToJMXAttributeNames(Object pojo) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Collection<Method> annotatedMethods = this.jmxAttributes.values();
        for (Method annotatedMethod : annotatedMethods) {
            try {
                String jmxName = this.getJMXAttributeName(annotatedMethod, pojo);
                PropertyDescriptor pd = this.getPropertyDescriptorForMethod(annotatedMethod);
                attrs.put(pd.getName(), jmxName);
            }
            catch (Exception e) {
                log.info((Object)"Failed to get PD for method", (Throwable)e);
            }
        }
        return attrs;
    }

    public Map<String, String> getJMXAttributeToBeanNames(Object pojo) {
        return this.swapKeyValues(this.getBeanToJMXAttributeNames(pojo));
    }

    protected <V, K> Map<V, K> swapKeyValues(Map<K, V> map) {
        HashMap<V, K> newMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    protected String printMap(Map<? extends Object, ? extends Object> map) {
        StringBuilder buff = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            buff.append("\t").append(entry.getKey().toString()).append(":").append(entry.getValue().toString()).append("\n");
        }
        return buff.toString();
    }

    public PropertyDescriptor getPropertyDescriptorForMethod(Method method) {
        for (PropertyDescriptor pd : this.propertyDescriptors.values()) {
            if (pd.getReadMethod() != null && pd.getReadMethod().equals(method)) {
                return pd;
            }
            if (pd.getWriteMethod() == null || !pd.getWriteMethod().equals(method)) continue;
            return pd;
        }
        throw new RuntimeException("No PropertyDescriptor Found For Method [" + method.getName() + "]");
    }

    protected void validatePojoType(Object pojo) {
        if (pojo == null) {
            throw new RuntimeException("Parameter null");
        }
        if (!pojo.getClass().equals(this.clazz)) {
            StringBuilder buff = new StringBuilder("Parameter of Invalid Type. Expected [");
            buff.append(this.clazz.getName()).append("] but received [");
            buff.append(pojo.getClass().getName()).append("]");
            throw new RuntimeException(buff.toString());
        }
    }

    public static void log(Object message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
    }

    public Set<String> getBeanAttributeNames() {
        return Collections.unmodifiableSortedSet(new TreeSet<String>(this.beanAttributeNames));
    }

    public Map<String, String> getBeanAttributeTypes() {
        return Collections.unmodifiableSortedMap((SortedMap)this.beanAttributeTypes);
    }

    public Map<String, String> getJMXAttributeTypes(Object pojo) {
        this.validatePojoType(pojo);
        TreeMap<String, String> jmxTypes = new TreeMap<String, String>();
        String name = null;
        String type = null;
        for (Method m : this.jmxAttributeGetters.values()) {
            if (m.getParameterTypes().length != 1) {
                throw new RuntimeException("Getter and Setter Types Managing Different Types");
            }
            jmxTypes.put(this.getJMXAttributeName(m, pojo), m.getReturnType().getName());
        }
        for (Method m : this.jmxAttributeSetters.values()) {
            name = this.getJMXAttributeName(m, pojo);
            type = m.getReturnType().getName();
            if (!jmxTypes.containsKey(name) || ((String)jmxTypes.get(name)).equals(type)) continue;
            throw new RuntimeException("Getter and Setter Types Managing Different Types");
        }
        return Collections.unmodifiableSortedMap((SortedMap)jmxTypes);
    }
}

