/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Tests if a numeric value is a probability.
*
* ## Notes
*
* -   A probability is defined as a numeric value on the closed interval `[0,1]`.
*
* @param x - value to test
* @returns boolean indicating whether the value is a probability
*
* @example
* var bool = isProbability( 0.5 );
* // returns true
*
* @example
* var bool = isProbability( 3.14 );
* // returns false
*
* @example
* var bool = isProbability( NaN );
* // returns false
*/
declare function isProbability( x: number ): boolean;


// EXPORTS //

export = isProbability;
