/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute a moving arithmetic mean and unbiased sample variance incrementally.
*
* @module @stdlib/stats/incr/mmeanvar
*
* @example
* var incrmmeanvar = require( '@stdlib/stats/incr/mmeanvar' );
*
* var accumulator = incrmmeanvar( 3 );
*
* var v = accumulator();
* // returns null
*
* v = accumulator( 2.0 );
* // returns [ 2.0, 0.0 ]
*
* v = accumulator( -5.0 );
* // returns [ -1.5, 24.5 ]
*
* v = accumulator( 3.0 );
* // returns [ 0.0, 19.0 ]
*
* v = accumulator( 5.0 );
* // returns [ 1.0, 28.0 ]
*
* v = accumulator();
* // returns [ 1.0, 28.0 ]
*/

// MODULES //

var incrmmeanvar = require( './main.js' );


// EXPORTS //

module.exports = incrmmeanvar;
