CHANGELOG for 5.4.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.4 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.4.0...v5.4.1

* 5.4.4 (2022-01-29)

 * security #cve-2022-xxxx [FrameworkBundle] Enable CSRF in FORM by default (jderusse)

* 5.4.3 (2022-01-28)

 * bug #45193 [FrameworkBundle] Fix missing arguments when a serialization default context is bound (ArnoudThibaut)
 * bug #44997 [Runtime] Fix --env and --no-debug with dotenv_overload (fancyweb)
 * bug #45188 [Dotenv] Fix bootEnv() override with .env.local.php when the env key already exists (fancyweb)
 * bug #45095 [Finder] Fix finding VCS re-included files in excluded directory (julienfalque)
 * bug #44987 [DoctrineBridge]  Fix automapping (mbabker)
 * bug #44860 [Validator] Fix Choice constraint with associative choices array (derrabus)
 * bug #44939 [Form] UrlType should not add protocol to emails (GromNaN)
 * bug #43149 Silence warnings during tty detection (neclimdul)
 * bug #45154 [Serializer] Fix AbstractObjectNormalizer not considering pseudo type false (Thomas Nunninger)
 * bug #45185 [Notifier] Fix encoding of messages with FreeMobileTransport (94noni)
 * bug #45181 [Console] Fix PHP 8.1 deprecation in ChoiceQuestion (BrokenSourceCode)
 * bug #44634 [HttpKernel] Fix compatibility with php bridge and already started php sessions (alexander-schranz)
 * bug #45174 [Notifier] Use the UTF-8 encoding in smsapi-notifier (marphi)
 * bug #45140 [Yaml] Making the parser stateless (mamazu)
 * bug #45109 [Console] fix restoring stty mode on CTRL+C (nicolas-grekas)
 * bug #45103 [Process] Avoid calling fclose on an already closed resource (Seldaek)
 * bug #44941 [RateLimiter] Resolve crash on near-round timestamps (xesxen)
 * bug #45088 [Console] fix parsing escaped chars in StringInput (nicolas-grekas)
 * bug #45096 [Cache] Throw exception if incompatible version of psr/simple-cache is used (colinodell)
 * bug #45067 [RateLimiter] Implicit conversion fix (brian978)
 * bug #45063 [DependencyInjection] remove arbitratry limitation to exclude inline services from bindings (nicolas-grekas)
 * bug #44986 [DependencyInjection] copy synthetic status when resolving child definitions (kbond)
 * bug #45073 [HttpClient] Fix Failed to open stream: Too many open files (adrienfr)
 * bug #45053 [Console] use STDOUT/ERR in ConsoleOutput to save opening too many file descriptors (nicolas-grekas)
 * bug #45029 [Cache] Set mtime of cache files 1 year into future if they do not expire (Blacksmoke16)
 * bug #45012 [DoctrineBridge] Fix invalid guess with enumType (jderusse)
 * bug #45015 [HttpClient] fix resetting DNS/etc when calling CurlHttpClient::reset() (nicolas-grekas)
 * bug #45004 [HttpClient] Remove deprecated usage of GuzzleHttp\Promise\promise_for (plozmun)
 * bug #44998 [FrameworkBundle] Allow default cache pools to be overwritten by user (Seldaek)
 * bug #44890 [HttpClient] Remove deprecated usage of `GuzzleHttp\Promise\queue` (GrahamCampbell)
 * bug #45002 [PropertyAccess] Fix handling of uninitialized property of anonymous class (filiplikavcan)
 * bug #44979 [DependencyInjection] Add iterable to possible binding type (vladimir.panivko)
 * bug #44976 [FrameworkBundle] Avoid calling rtrim(null, '/') in AssetsInstallCommand (pavol-tk, GromNaN)
 * bug #44879 [DependencyInjection] Ignore argument type check in CheckTypeDeclarationsPass if it's a Definition with a factory (fancyweb)
 * bug #44920 Use correct tag for ExpoTransportFactory service (jschaedl)
 * bug #44931 Allow a zero time-limit for messenger:consume (fritzmg)
 * bug #44932 [DependencyInjection] Fix nested env var with resolve processor (Laurent Moreau)
 * bug #44912 [Console] Allow OutputFormatter::escape() to be used for escaping URLs used in <href> (Seldaek)
 * bug #44877 [Validator] Error using CssColor with doctrine annotations (sormes)
 * bug #44878 [HttpClient] Turn negative timeout to a very long timeout (fancyweb)
 * bug #44854 [Validator] throw when Constraint::_construct() has not been called (nicolas-grekas)
 * bug #44857 [Translation] [LocoProvider] Fix use of asset ids (danut007ro)

* 5.4.2 (2021-12-29)

 * bug #44828 [Lock] Release DoctrineDbalPostgreSqlStore connection lock on failure (simon-watiau)
 * bug #44838 [DependencyInjection][HttpKernel] Fix enum typed bindings (ogizanagi)
 * bug #44723 [Lock] Release PostgreSqlStore connection lock on failure (simon-watiau) * commit 'e5b2f9efba':   [Lock] Release PostgreSqlStore connection lock on failure
 * bug #44826 [HttpKernel] Do not attempt to register enum arguments in controller service locator (ogizanagi)
 * bug #44824 [Mime] Fix missing sprintf in DkimSigner (alamirault)
 * bug #44816 [Translation] [LocoProvider] Use rawurlencode and separate tag setting (danut007ro)
 * bug #44805 [Security] fix unserializing session payloads from v4 (nicolas-grekas)
 * bug #44820 [Cache] Don't lock when doing nested computations (nicolas-grekas)
 * bug #44807 [Messenger] fix Redis support on 32b arch (nicolas-grekas)
 * bug #44759 [HttpFoundation] Fix notice when HTTP_PHP_AUTH_USER passed without pass (Vitali Tsyrkin)
 * bug #44809 [WebProfilerBundle] relax return type for memory data collector (94noni)
 * bug #44799 [Cache] fix compat with apcu < 5.1.10 (nicolas-grekas)
 * bug #44764 [Form] Expand FormView key to include int (biozshock)
 * bug #44730 [Console] Fix autocompletion of argument with default value (GromNaN)
 * bug #44637 [PropertyInfo] PhpStan extractor nested object fix (rmikalkenas)
 * bug #44085 [Translation] Fix TranslationPullCommand with ICU translations (Kocal)
 * bug #44578 [PropertyInfo] Fix phpstan extractor issues (ostrolucky)
 * bug #44771 [Notifier] Use correct factory for the msteams transport (veewee)
 * bug #44618 [HttpKernel] Fix SessionListener without session in request (shyim)
 * bug #44743 [HttpClient] fix checking for recent curl consts (nicolas-grekas)
 * bug #44752 [Security/Http] Fix cookie clearing on logout (maxhelias)
 * bug #44732 [Mime] Relaxing in-reply-to header validation (ThomasLandauer)
 * bug #44714 [WebProfilerBundle] fix Email HTML preview (94noni)
 * bug #44728 [Mime] Fix encoding filenames in multipart/form-data (nicolas-grekas)
 * bug #44602 [Serializer] Improve UidNormalizer denormalize error message (fancyweb)
 * bug #44383 [Lock] Create tables in transaction only if supported by driver (martinssipenko)
 * bug #44518 [HttpFoundation] Take php session.cookie settings into account (simonchrz)
 * bug #44719 [ErrorHandler] fix on patching return types on Windows (nicolas-grekas)
 * bug #44710 [DependencyInjection] fix linting callable classes (nicolas-grekas)
 * bug #44639 [DependencyInjection] Cast tag attribute value to string (ruudk)
 * bug #44473 [Validator] Restore default locale in ConstraintValidatorTestCase (rodnaph)
 * bug #44682 [FrameworkBundle] alias `cache.app.taggable` to `cache.app` if using `cache.adapter.redis_tag_aware` (kbond)
 * bug #44649 [HttpKernel] fix how configuring log-level and status-code by exception works (nicolas-grekas)
 * bug #44667 [Cache] Revert "feature #41989  make `LockRegistry` use semaphores when possible" (nicolas-grekas)
 * bug #44671 [HttpClient] Fix tracing requests made after calling withOptions() (nicolas-grekas)
 * bug #44577 [Cache] Fix proxy no expiration to the Redis (Sergey Belyshkin)
 * bug #44669 [Cache] disable lock on CLI (nicolas-grekas)
 * bug #44598 [Translation] Handle the blank-translation in Loco Adapter (kgonella)
 * bug #44448 [Validator] Allow Sequence constraint to be applied onto class as an attribute (sidz)
 * bug #44354 [RateLimiter] Make RateLimiter resilient to timeShifting (jderusse)
 * bug #44600 [Serializer] Fix denormalizing custom class in UidNormalizer (fancyweb)
 * bug #44537 [Config] In XmlUtils, avoid converting from octal every string starting with a 0 (alexandre-daubois)
 * bug #44510 [Workflow] Fix eventsToDispatch parameter setup for StateMachine (Olexandr Kalaidzhy)
 * bug #44625 [HttpClient] fix monitoring responses issued before reset() (nicolas-grekas)
 * bug #44623 [HttpClient] Fix dealing with "HTTP/1.1 000 " responses (nicolas-grekas)
 * bug #44430 [PropertyInfo] Fix aliased namespace matching (Korbeil)
 * bug #44601 [HttpClient] Fix closing curl-multi handle too early on destruct (nicolas-grekas)
 * bug #44571 [HttpClient] Don't reset timeout counter when initializing requests (nicolas-grekas)
 * bug #44479 [HttpClient] Double check if handle is complete (Nyholm)
 * bug #44418 [DependencyInjection] Resolve ChildDefinition in AbstractRecursivePass (fancyweb)
 * bug #44474 [Translation] [Bridge] [Lokalise] Fix push keys to lokalise. Closes #… (olegmifle)
 * bug #43164 [FrameworkBundle] Fix cache pool configuration with one adapter and one provider (fancyweb)
 * bug #44419 [PropertyAccess] Fix accessing public property on Object (kevcomparadise)
 * bug #44565 [FrameworkBundle] Use correct cookie domain in loginUser() (wouterj)
 * bug #44538 [Process] fixed uppercase ARGC and ARGV should also be skipped (rbaarsma)
 * bug #44438 [HttpClient] Fix handling thrown \Exception in \Generator in MockResponse (fancyweb)
 * bug #44469 [String] Fix requiring wcswitch table several times (fancyweb)
 * bug #44539 [Lock] Fix missing argument in PostgreSqlStore::putOffExpiration with DBAL connection (GromNaN)

* 5.4.1 (2021-12-09)

 * bug #44490 [DependencyInjection][Messenger] Add auto-registration for BatchHandlerInterface (GaryPEGEOT)
 * bug #44523 [Console] Fix polyfill-php73 requirement (Seldaek)
 * bug #44502 [HttpFoundation] do not call preg_match() on null (xabbuh)
 * bug #44475 [Console] Handle alias in completion script (GromNaN)
 * bug #44481 [FrameworkBundle] Fix loginUser() causing deprecation (wouterj)
 * bug #44416 [Translation] Make http requests synchronous when reading the Loco API (Kocal)
 * bug #44437 [HttpKernel] Fix wrong usage of SessionUtils::popSessionCookie (simonchrz)
 * bug #44350 [Translation] Fix TranslationTrait (Tomasz Kusy)
 * bug #44460 [SecurityBundle] Fix ambiguous deprecation message on missing provider (chalasr)
 * bug #44467 [Console] Fix parameter types for `ProcessHelper::mustRun()` (derrabus)
 * bug #44427 [FrameworkBundle] Fix compatibility with symfony/security-core 6.x (deps=high tests) (wouterj)
 * bug #44424 [SecurityBundle] Don't rely on deprecated strategy constants (derrabus)
 * bug #44399 Prevent infinite nesting of lazy `ObjectManager` instances when `ObjectManager` is reset (Ocramius)
 * bug #44395 [HttpKernel] fix sending Vary: Accept-Language when appropriate (nicolas-grekas)
 * bug #44385 [DependencyInjection] Skip parameter attribute configurators in AttributeAutoconfigurationPass if we can't get the constructor reflector (fancyweb)
 * bug #44359 Avoid duplicated session listener registration in tests (alexander-schranz)
 * bug #44375 [DoctrineBridge] fix calling get_class on non-object (kbond)
 * bug #44378 [HttpFoundation] fix SessionHandlerFactory using connections (dmaicher)
 * bug #44365 [SecurityBundle]  Fix invalid reference with `always_authenticate_before_granting` (chalasr)
 * bug #44361 [HttpClient] Fix handling error info in MockResponse (fancyweb)
 * bug #44370 [Lock] create lock table if it does not exist (martinssipenko)

* 5.4.0 (2021-11-29)

 * bug #44309 [Messenger] Leverage DBAL's getNativeConnection() method (derrabus)
 * bug #44300 [FrameworkBundle] Fix property-info phpstan extractor discovery (1ed)
 * feature #44271 [Notifier] add Vonage bridge to replace the Nexmo one (nicolas-grekas)
 * bug #44187 [Translation] [Loco] Fix idempotency of LocoProvider write method (welcoMattic)
 * bug #43992 [Security] Do not overwrite already stored tokens for REMOTE_USER authentication (stlrnz)
 * bug #43876 [Validator] Fix validation for single level domains (HypeMC)
 * bug #44327 [Debug][ErrorHandler] Increased the reserved memory from 10k to 32k (sakalys)
 * bug #44261 [Process] intersect with getenv() in case-insensitive manner to get default envs (stable-staple)
 * bug #44295 [Serializer] fix support for lazy/unset properties (nicolas-grekas)
 * bug #44277 [Notifier] Fix AllMySms bridge body content (afiocre)
 * bug #44269 [DoctrineBridge] Revert " add support for the JSON type" (dunglas)

* 5.4.0-RC1 (2021-11-24)

 * security #cve-2021-41268 [SecurityBundle] Default signature_properties to the previous behavior (wouterj)
 * security #cve-2021-41267 [HttpKernel] Fix missing extra trusted header in sub-request (jderusse)
 * security #cve-2021-41270 [Serializer] Use single quote to escape formulas (jderusse)
 * bug #44230 [Console] Add Suggestion class for more advanced completion suggestion (wouterj)
 * bug #44232 [Cache] fix connecting to local Redis sockets (nicolas-grekas)
 * bug #44204 [HttpClient] fix closing curl multi handle when destructing client (nicolas-grekas)
 * bug #44208 [Process] exclude argv/argc from possible default env vars (nicolas-grekas)
 * bug #44188 [VarExporter] fix exporting declared but unset properties when __sleep() is implemented (nicolas-grekas)
 * bug #44176 [Console] Default ansi option to null (jderusse)
 * bug #44179 [WebProfilerBundle] Fix JS error when toolbar is reloaded (jderusse)
 * bug #44172 [Security] Guard is incompatible with Symfony 6 (derrabus)
 * bug #44119 [HttpClient][Mime] Add correct IDN flags for IDNA2008 compliance (j-bernard)
 * bug #44139 [WebProfilerBundle] Prevent installation of incompatible mailer component versions (Anne-Julia Seitz)
 * bug #43917 Allow autodetecting mapping type for any object (franmomu)
 * bug #44131 [Yaml] properly parse quoted strings tagged with !!str (xabbuh)
 * bug #42323 [TwigBridge] do not merge label classes into expanded choice labels (xabbuh)

* 5.4.0-BETA3 (2021-11-18)

 * feature #44125 Add a setter on DateTimeNormalizer to change the default context at runtime (Seldaek)
 * bug #44110 [FrameworkBundle] Fix default PHP attributes support in validation and serializer configuration when doctrine/annotations is not installed with PHP 8 (fancyweb)
 * bug #44115 [WebProfilerBundle] Tweak the colors of the security panel (javiereguiluz)
 * bug #44121 [Serializer] fix support for lazy properties (nicolas-grekas)
 * bug #44108 [FrameworkBundle][Messenger] remove `FlattenExceptionNormalizer` definition if serializer not available (kbond)
 * bug #44111 [Serializer] fix support for unset properties on PHP < 7.4 (nicolas-grekas)
 * bug #44098 [DependencyInjection] fix preloading (nicolas-grekas)
 * bug #44065 [FrameworkBundle] Add framework config for DBAL cache adapter (GromNaN)
 * bug #44096 Make ExpressionVoter Cacheable (jderusse)
 * bug #44070 [Process] intersect with getenv() to populate default envs (nicolas-grekas)
 * feature #43181 Allow AbstractDoctrineExtension implementations to support the newer bundle structure (mbabker)
 * bug #44060 [Cache] Fix calculate ttl in couchbase sdk 3.0 (ajcerezo)
 * bug #43990 [Translation] [Loco] Generate id parameter instead of letting Loco do it (welcoMattic)
 * bug #44043 [Cache] fix dbindex Redis (a1812)
 * feature #44015 [Cache] Decrease the probability of invalidation loss on tag eviction (nicolas-grekas)
 * bug #44064 [Cache] fix releasing not acquired locks (nicolas-grekas)
 * bug #44063 [DependencyInjection] fix creating 2nd container instances (nicolas-grekas)
 * bug #44051 [Notifier] Fix package name (fabpot)
 * bug #44050 [Notifier] Fix package names (fabpot)

* 5.4.0-BETA2 (2021-11-14)

 * bug #44042 Fix DateIntervalToStringTransformer::transform() doc (BenMorel)
 * bug #44034 [Yaml] don't try to replace references in quoted strings (xabbuh)
 * bug #44013 [ErrorHandler] fix parsing ``@param`` with dollars in the description (nicolas-grekas)
 * bug #44010 [DependencyInjection] fix auto-refresh when inline_factories is enabled (nicolas-grekas)
 * bug #44028 [ErrorHandler] Fix FlattenException::setPrevious argument typing (welcoMattic)
 * bug #44016 [SecurityBundle] Fix listing listeners in profiler when authenticator manager is disabled (94noni)
 * bug #44012 [DependencyInjection] fix inlining when non-shared services are involved (nicolas-grekas)
 * bug #44002 [Cache] Fix Memory leak (a1812)
 * bug #43993 [FrameworkBundle] fix deprecation message (nicolas-grekas)
 * feature #43985 [HttpClient] Implement ResetInterface for all http clients (rmikalkenas)
 * bug #43981 [FrameworkBundle] fix registering late resettable services (nicolas-grekas)
 * bug #43988 [DoctrineBridge] add support for the JSON type (dunglas)
 * bug #43987 [PhpUnitBridge] Fix Uncaught ValueError (dunglas)
 * feature #43983 [HttpKernel] allow ignoring kernel.reset methods that don't exist (nicolas-grekas)
 * bug #43967 [Loco] Fix Loco Provider ID and pull & push local messages reading (welcoMattic)
 * bug #43961 [HttpClient] Curl http client has to reinit curl multi handle on reset (rmikalkenas)
 * bug #43930 [DependencyInjection] Fix support for unions/intersections together with `ServiceSubscriberInterface` (kbond)
 * bug #43948 [Asset][Security] Fixed leftover deprecations PHP 8.1 (michaljusiega)
 * bug #43944 [Yaml] revert using functions provided by polyfill packages (xabbuh)
 * bug #43940 [FrameworkBundle] Fix logic in workflow:dump between workflow name and workflow id (noniagriconomie)
 * bug #43945 [Runtime] fix defining APP_DEBUG when Dotenv is not enabled (nicolas-grekas)

* 5.4.0-BETA1 (2021-11-05)

 * feature #43916 [PropertyInfo] Support the list pseudo-type (derrabus)
 * feature #43850 Add completion for DebugConfig name and path arguments (eclairia, Adrien Jourdier)
 * feature #43838 feat: add completion for DebugAutowiring search argument (eclairia, Adrien Jourdier)
 * feature #38464 [Routing] Add support for aliasing routes (Lctrs)
 * feature #43923 [Console] Open CompleteCommand for custom outputs (wouterj)
 * feature #43663 [Messenger] Add  command completion for failed messages (scyzoryck)
 * feature #43857 [Framework] Add completion to debug:container (GromNaN)
 * feature #43891 [Messenger] Add completion to command messenger:consume (GromNaN)
 * feature #42471 Add generic types to traversable implementations (derrabus)
 * feature #43898 [Security] Make the abstract Voter class implement CacheableVoterInterface (javiereguiluz)
 * feature #43848 [FrameworkBundle] Add completion for workflow:dump (StaffNowa)
 * feature #43837 [Finder] Add .gitignore nested negated patterns support (julienfalque)
 * feature #43754 Determine attribute or annotation type for directories (cinamo)
 * feature #43846 Add completion for debug:twig (StaffNowa)
 * feature #43138 [FrameworkBundle][HttpKernel] Add the ability to enable the profiler using a parameter (dunglas)
 * feature #40457 [PropertyInfo] Add `PhpStanExtractor` (Korbeil)
 * feature #40262 [DoctrineBridge] Param as connection in `*.event_subscriber/listener` tags (wbloszyk)
 * feature #43354 [Messenger] allow processing messages in batches (nicolas-grekas)
 * feature #43835 [SecurityBundle] Deprecate not configuring explicitly a provider for custom_authenticators when there is more than one registered provider (lyrixx)
 * feature #43598 [Console] add suggestions for debug commands: firewall, form, messenger, router (IonBazan)
 * feature #41993 [Security] Prevent `FormLoginAuthenticator` from responding to requests that should be handled by `JsonLoginAuthenticator` (abunch)
 * feature #43751 [WebProfilerBundle] Add a "preview" tab in mailer profiler for HTML email (lyrixx)
 * feature #43644 [FrameworkBundle] Add completion to debug:translation command (alexandre-daubois)
 * feature #43653 [PasswordHasher] Add autocompletion for security commands (noniagriconomie)
 * feature #43676 [FrameworkBundle] Add completion feature on translation:update command (stephenkhoo)
 * feature #43672 [Translation] Add completion feature on translation pull and push commands (welcoMattic)
 * feature #43060 [RateLimiter] Add support for long intervals (months and years) (alexandre-daubois)
 * feature #42177 [Security][SecurityBundle] Implement ADM strategies as dedicated classes (derrabus)
 * feature #43804 [DependencyInjection][FrameworkBundle][SecurityBundle][TwigBundle] Deprecate Composer 1 (derrabus)
 * feature #43796 [Filesystem] Add third argument `$lockFile` to `Filesystem::appendToFile()` (fwolfsjaeger)
 * feature #42414 [Notifier] Add Expo bridge (zairigimad)
 * feature #43066 [Security] Cache voters that will always abstain (jderusse)
 * feature #43758 [FrameworkBundle] Rename translation:update to translation:extract (welcoMattic)
 * feature #41414 Support `statusCode` default param when loading template directly via route (dayallnash)
 * feature #42238 [DependencyInjection] Add `SubscribedService` attribute, deprecate current `ServiceSubscriberTrait` usage (kbond)
 * feature #38542 [FrameworkBundle][Serializer] Allow serializer default context configuration (soyuka)
 * feature #43755 [Dotenv] Add $overrideExistingVars to bootEnv() and  loadEnv() and dotenv_overload to SymfonyRuntime (fancyweb)
 * feature #43671 add ResponseIsUnprocessable (garak)
 * feature #43682 [FrameworkBundle] Add completion for config:dump-reference (StaffNowa)
 * feature #43588 [Messenger] Autoconfigurable attributes (alirezamirsepassi)
 * feature #43593 [Validator] Add CidrValidator to allow validation of CIDR notations (popsorin)
 * feature #43683 [VarDumper] Add completion to server:dump command (alexandre-daubois)
 * feature #43677 [RateLimiter] bug #42194  fix: sliding window policy to use microtime (jlekowski)
 * feature #43679 [VarDumper] Add support for Fiber (lyrixx)
 * feature #43680 Add suggestions for the option 'format' of lints commands: twig, yaml and xliff (makraz)
 * feature #43621 Add completion for cache:pool:clear and cache:pool:delete commands (andyexeter)
 * feature #43639 [Uid] Allow use autocompletion (StaffNowa)
 * feature #43626 [Console] [Framework] Add completion to secrets:set and fix secrets:remove (GromNaN)
 * feature #43640 [Console] Add completion to messenger:setup-transports command (Tayfun74)
 * feature #43615 feat: add completion for CompletionCommand "shell" argument (dkarlovi)
 * feature #43595 [Console] `SymfonyStyle` enhancements (kbond)
 * feature #41268 [HttpFoundation] Allow setting session options via DSN (makraz)
 * feature #43596 [Console] Add completion to help & list commands (GromNaN)
 * feature #43576 [Messenger] subtract handling time from sleep time in worker (nicolas-grekas)
 * feature #43386 [DependencyInjection] Extend TaggedIterator and TaggedLocator Attributes with able to specify defaultIndexMethod for #[TaggerIterator] and #[TaggedLocator] (fractalzombie)
 * feature #42251 [Console] Bash completion integration (wouterj)
 * feature #39402 [Notifier] Add push channel to notifier (norkunas)
 * feature #43332 [Lock] Split PdoStore into DoctrineDbalStore (GromNaN)
 * feature #43362 [Cache] Split PdoAdapter into DoctrineDbalAdapter (GromNaN)
 * feature #42580 [Console][FrameworkBundle] Add DotenvDebugCommand (chr-hertel)
 * feature #43411 [HttpFoundation] Deprecate passing null as $requestIp in IpUtils (W0rma)
 * feature #43526 Add a warning in WDT when using symfony/symfony (fabpot)
 * feature #43481 [String] Add `trimSuffix()` and `trimPrefix()` methods (nicolas-grekas)
 * feature #43497 [Notifier] [Twilio] Ensure from/sender is valid via regex (OskarStark)
 * feature #43492 Lower log level in case of retry (jderusse)
 * feature #43479 [DependencyInjection] autowire union and intersection types (nicolas-grekas)
 * feature #43134 [Notifier] Add sms77 Notifier Bridge (matthiez)
 * feature #43378 [HttpFoundation] Deprecate upload_progress.* and url_rewriter.tags session options (Matthew Covey)
 * feature #42582 [Security] Add authenticators info to the profiler (chalasr)
 * feature #42723 [Messenger] Log when worker should stop and when `SIGTERM` is received (ruudk)
 * feature #40168 [Validator] Added `CssColor` constraint (welcoMattic)
 * feature #43328 [MonologBridge] Deprecate the Swiftmailer handler (fabpot)
 * feature #43322 [MonologBridge] Deprecates ResetLoggersWorkerSubscriber (lyrixx)
 * feature #43108 [HttpKernel] Add basic support for language negotiation (GregoireHebert)
 * feature #41265 [Messenger] Add a middleware to log when transaction has been left open (lyrixx)
 * feature #43280 [HttpClient] Add method to set response factory in mock client (greeflas)
 * feature #42610 [Dotenv] Reimplementing symfony/flex' dump-env as a Symfony command (abdielcs, nicolas-grekas)
 * feature #42244 [HttpKernel] Add support for configuring log level, and status code by exception class (lyrixx)
 * feature #43236 [Security] Add alias for FirewallMapInterface to `@security`.firewall.map (lyrixx)
 * feature #43150 [Finder] Add recursive .gitignore files support (julienfalque)
 * feature #41608 [Runtime] Possibility to define the env and/or debug key (maxhelias)
 * feature #42257 [Messenger] Allow using user's serializer for message do not fit the expected JSON structure (welcoMattic)
 * feature #43148 [Cache] Throw ValueError in debug mode when serialization fails (nicolas-grekas)
 * feature #43139 [Notifier] Mattermost Notifier option to post in an other channel (nathanaelmartel)
 * feature #42335 [Messenger] Add `WorkerMetadata` to `Worker` class. (okwinza)
 * feature #42712 [Serializer] Save missing arguments in MissingConstructorArgumentsException (BafS)
 * feature #43004 [Serializer] Throw NotNormalizableValueException when type is not known or not in body in discriminator map (lyrixx)
 * feature #43121 [Notifier] [GoogleChat] remove support for deprecated "threadKey" parameter (IonBazan)
 * feature #42338 [DomCrawler] Added Crawler::innerText() method (Bilge)
 * feature #43095 [Form] Add the EnumType (derrabus)
 * feature #43094 [Console] Add support of RGB functional notation (alexandre-daubois)
 * feature #43098 [Validator] Add error's uid to `Count` and `Length` constraints with "exactly" option enabled (VladGapanovich)
 * feature #42668 [Yaml] Use more concise float representation in dump (dev97)
 * feature #43017 [HttpFoundation] Map `multipart/form-data` as `form` Content-Type (keichinger)
 * feature #43015 [DependencyInjection] Allow injecting tagged iterator as service locator arguments (IonBazan)
 * feature #42991 [FrameworkBundle] Add configureContainer(), configureRoutes() and getConfigDir() to MicroKernelTrait (nicolas-grekas)
 * feature #43018 [Mailer] Adding support for TagHeader and MetadataHeader to the Sendgrid API transport (gnito-org)
 * feature #42988 [ErrorHandler] Add helper script to patch type declarations (wouterj)
 * feature #42982 Add Session Token to Amazon Mailer (Jubeki)
 * feature #42959 [DependencyInjection] Make auto-aliases private by default (nicolas-grekas)
 * feature #42957 [RateLimiter][Runtime][Translation] remove ``@experimental`` flag (nicolas-grekas)
 * feature #41163 [Mesenger] Add support for reseting container services between 2 messages (lyrixx)
 * feature #41858 [Translation] Translate translatable parameters (kylekatarnls)
 * feature #42941 Implement Message Stream for Postmark Mailer (driesvints)
 * feature #42532 [DependencyInjection] Sort services in service locator according to priority (BoShurik)
 * feature #42502 [Serializer] Add support for collecting type error during denormalization (lyrixx)
 * feature #40120 [Cache] Add CouchbaseCollectionAdapter compatibility with sdk 3.0.0 (ajcerezo)
 * feature #42965 [Cache] Deprecate support for Doctrine Cache (derrabus)
 * feature #41615 [Serializer] Add option to skip uninitialized typed properties (vuryss)
 * feature #41566 [FrameworkBundle] Introduced new method for getting bundles config path (a-menshchikov)
 * feature #42881 [Console] Add more context when CommandIsSuccessful fails (yoannrenard)
 * feature #42900 [HttpFoundation] Add a flag to hasSession to distinguished session from factory (jderusse)
 * feature #41390 [HttpKernel] Add session cookie handling in cli context (alexander-schranz, Nyholm)
 * feature #42800 Display the roles of the logged-in user in the Web Debug Toolbar (NicoHaase)
 * feature #42872 [Mime] Update mime types (fabpot)
 * feature #42039 [DependencyInjection] Autoconfigurable attributes on methods, properties and parameters (ruudk)
 * feature #42710 [Mailer] Added OhMySMTP Bridge (paul-oms)
 * feature #40987 [Config] Handle ignoreExtraKeys in config builder (HypeMC)
 * feature #42426 [Notifier] Autoconfigure chatter.transport_factory (ismail1432)
 * feature #42748 [Notifier] Add Esendex message ID to SentMessage object (benr77)
 * feature #42526 [FrameworkBundle] Add BrowserKitAssertionsTrait::assertThatForBrowser (koenreiniers)
 * feature #41527 [Ldap] Fixing the behaviour of getting LDAP Attributes (mr-sven)
 * feature #42623 [ErrorHandler] Turn return-type annotations into deprecations by default + add mode to turn them into native types (nicolas-grekas)
 * feature #42696 [Notifier] Mark Transport as final (fabpot)
 * feature #42433 [Notifier] Add more explicit error if a SMSChannel doesn't have a Recipient (ismail1432)
 * feature #42619 [Serializer] Deprecate support for returning empty, iterable, countable, raw object when normalizing (lyrixx)
 * feature #42662 [Mailer] Consume a PSR-14 event dispatcher (derrabus)
 * feature #42625 [DependencyInjection] Add service_closure() to the PHP-DSL (HypeMC)
 * feature #42650 [Security] make TokenInterface::getUser() nullable to tell about unauthenticated tokens (nicolas-grekas)
 * feature #42632 [Console] Deprecate `HelperSet::setCommand()` and `getCommand()` (derrabus)
 * feature #41994 [Validator] Add support of nested attributes (alexandre-daubois)
 * feature #42595 Fix incompatibilities with upcoming security 6.0 (wouterj)
 * feature #42578 [Security] Deprecate legacy remember me services (wouterj)
 * feature #42516 [Security] Deprecate built-in authentication entry points (wouterj)
 * feature #42387 [Form] Deprecate calling FormErrorIterator::children() if the current element is not iterable (W0rma)
 * feature #39641 [Yaml] Add --exclude and negatable --parse-tags option to lint:yaml command (christingruber)
 * feature #42510 [Security] Deprecate remaining anonymous checks (wouterj)
 * feature #42423 [Security] Deprecate AnonymousToken, non-UserInterface users, and token credentials (wouterj)
 * feature #41954 [Filesystem] Add the Path class (theofidry)
 * feature #42442 [FrameworkBundle] Deprecate AbstractController::get() and has() (fabpot)
 * feature #42422 Clarify goals of AbstractController (fabpot)
 * feature #42420 [Security] Deprecate legacy signatures (wouterj)
 * feature #41754 [SecurityBundle] Create a smooth upgrade path for security factories (wouterj)
 * feature #42198 [Security] Deprecate `PassportInterface` (chalasr)
 * feature #42332 [HttpFoundation] Add `litespeed_finish_request` to `Response` (thomas2411)
 * feature #42286 [HttpFoundation] Add `SessionFactoryInterface` (kbond)
 * feature #42392 [HttpFoundation] Mark Request::get() internal (ro0NL)
 * feature #39601 [Notifier] add `SentMessageEvent` and `FailedMessageEvent` (ismail1432)
 * feature #42188 [Notifier] Add FakeChat Logger transport (noniagriconomie)
 * feature #41522 [Notifier] Add TurboSms Bridge (fre5h)
 * feature #42337 [Validator] Remove internal from `ConstraintViolationAssertion` (jordisala1991)
 * feature #42123 [Notifier] Add FakeSMS Logger transport (noniagriconomie)
 * feature #42297 [Serializer] Add support for serializing empty array as object (lyrixx)
 * feature #42326 [Security] Deprecate remaining `LogoutHandlerInterface` implementations (chalasr)
 * feature #42219 [Mailer] Add support of ping_threshold to SesTransportFactory (Tyraelqp)
 * feature #40052 [ErrorHandler] Add button to copy the path where error is thrown (lmillucci)
 * feature #38495 [Asset] [DX] Option to make asset manifests strict on missing item (GromNaN)
 * feature #39828 [Translation] XliffLintCommand supports Github Actions annotations (YaFou)
 * feature #39826 [TwigBridge] LintCommand supports Github Actions annotations (YaFou)
 * feature #39141 [Notifier] Add Amazon SNS bridge (adrien-chinour)
 * feature #42240 [Serializer] Add support for preserving empty object in object property (lyrixx)
 * feature #42239 [Notifier] Add Yunpian Notifier Bridge (welcoMattic)
 * feature #42195 [WebProfilerBundle] Redesigned the log section (javiereguiluz)
 * feature #42163 [Messenger] [Redis] Prepare turning `delete_after_ack` to `true` in 6.0 (chalasr)
 * feature #42180 [Notifier] Add bridge for smsc.ru (kozlice)
 * feature #42137 [Finder] Make Comparator immutable (derrabus)
 * feature #42127 [ExpressionLanguage] Store compiler and evaluator as closures (derrabus)
 * feature #42094 [Notifier] [Slack] Throw error if maximum block limit is reached for slack message options (norkunas)
 * feature #42050 [Security] Deprecate `TokenInterface::isAuthenticated()` (chalasr)
 * feature #42090 [Notifier] [Slack] Include additional errors to slack notifier error message (norkunas)
 * feature #41989 [Cache] make `LockRegistry` use semaphores when possible (nicolas-grekas)
 * feature #41965 [Security] Deprecate "always authenticate" and "exception on no token" (wouterj)
 * feature #41962 add ability to style doubles and integers independently (1ma)
 * feature #40830 [Serializer] Add support of PHP backed enumerations (alexandre-daubois)
 * feature #40908 [Cache] Deprecate DoctrineProvider (derrabus)
 * feature #41717 Allow TranslatableMessage object in form option 'help' (scuben)
 * feature #41705 [Notifier] add Mailjet SMS bridge (jnadaud)
 * feature #41851 Add TesterTrait::assertCommandIsSuccessful() helper (yoannrenard)
 * feature #39623 [Messenger] Added StopWorkerException (lyrixx)
 * feature #41292 [Workflow] Add support for getting updated context after a transition (lyrixx)
 * feature #41154 [Validator] Add support for `ConstraintViolationList::createFromMessage()` (lyrixx)
 * feature #41874 [SecurityBundle] Hide security toolbar if no firewall matched (wouterj)
 * feature #41375 [Notifier] Add MessageMedia Bridge (vuphuong87)
 * feature #41923 [EventDispatcher] Deprecate configuring tags on RegisterListenersPass (derrabus)
 * feature #41802 [Uid] Add NilUlid (fancyweb)
 * feature #40738 [Notifier] Add options to Microsoft Teams notifier (OskarStark)
 * feature #41172 [Notifier] Add Telnyx notifier bridge (StaffNowa)
 * feature #41770 [HttpClient] Add default base_uri to MockHttpClient (nicolas-grekas)
 * feature #41205 [TwigBridge] Add `encore_entry_*_tags()` to UndefinedCallableHandler, as no-op (nicolas-grekas)
 * feature #41786 [FrameworkBundle] Add commented base64 version of secrets' keys (nicolas-grekas)
 * feature #41432 [WebProfilerBundle] Improved the light/dark theme switching (javiereguiluz)
 * feature #41540 [VarDumper] Add casters for Symfony UUIDs and ULIDs (fancyweb)
 * feature #41530 [FrameworkBundle] Deprecate the public `profiler` service to private (nicolas-grekas)
 * feature #41199 [FrameworkBundle] Deprecate the `AdapterInterface` autowiring alias, use `CacheItemPoolInterface` instead (nicolas-grekas)
 * feature #41203 [FrameworkBundle] Add autowiring alias for `HttpCache\StoreInterface` (nicolas-grekas)

